/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.util.RecipeMatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TangyuanRecipe
implements Recipe<SimpleContainer> {
    private final NonNullList<Ingredient> inputItems;
    private final ItemStack output;
    private final ResourceLocation id;
    private final ItemStack container;
    private final Ingredient tool;
    private final ItemStack result_cache;
    private final boolean finished;

    public TangyuanRecipe(NonNullList<Ingredient> ingredient, ItemStack output, ItemStack container, ItemStack last_result, boolean finish, Ingredient tool_item, ResourceLocation id) {
        this.inputItems = ingredient;
        this.output = output;
        this.id = id;
        this.container = container.m_41619_() ? ItemStack.f_41583_ : container;
        this.result_cache = last_result.m_41619_() ? ItemStack.f_41583_ : last_result;
        this.finished = finish;
        this.tool = tool_item;
    }

    public boolean matches(SimpleContainer inv, Level pLevel) {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int i = 0;
        if (this.container.m_41619_() || this.getContainer().m_150930_(inv.m_8020_(4).m_41720_())) {
            boolean correct_order;
            ItemStack stack = inv.m_8020_(6);
            boolean bl = correct_order = this.getCacheItem().m_150930_(stack.m_41720_()) && this.getCacheItem().m_41784_().equals((Object)stack.m_41784_());
            if (this.result_cache.m_41619_() || correct_order) {
                for (int j = 0; j < 4; ++j) {
                    ItemStack itemstack = inv.m_8020_(j);
                    if (itemstack.m_41619_()) continue;
                    ++i;
                    inputs.add(itemstack);
                }
                System.out.println("\u8f93\u5165\u7269\u54c1\u6570\u91cf\uff1a" + i + ",\u8f93\u5165\u7269\u54c1\uff1a" + inputs);
            } else {
                System.out.println("\u7f13\u5b58\u4e0d\u5bf9");
            }
        } else {
            System.out.println("\u5bb9\u5668\u4e0d\u5bf9");
        }
        return i == this.inputItems.size() && RecipeMatcher.findMatches(inputs, this.inputItems) != null;
    }

    public ItemStack assemble(SimpleContainer pContainer, RegistryAccess pRegistryAccess) {
        ItemStack result = this.output.m_41777_();
        CompoundTag outputNBT = result.m_41783_();
        if (outputNBT != null && !outputNBT.m_128456_()) {
            result.m_41751_(outputNBT);
        }
        return result;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack getContainer() {
        return this.container.m_41777_();
    }

    public ItemStack getCacheItem() {
        return this.result_cache.m_41777_();
    }

    public Ingredient getTool() {
        return this.tool;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return this.output.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        return this.inputItems;
    }

    public static class Serializer
    implements RecipeSerializer<TangyuanRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("immortalers_delight", "tangyuan");

        public TangyuanRecipe fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)pSerializedRecipe, (String)"ingredients");
            NonNullList inputs = NonNullList.m_122779_();
            for (int i = 0; i < ingredients.size(); ++i) {
                inputs.add((Object)Ingredient.m_43917_((JsonElement)ingredients.get(i)));
            }
            ItemStack output = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"output"), (boolean)true);
            ItemStack container = GsonHelper.m_13900_((JsonObject)pSerializedRecipe, (String)"container") ? CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"container"), (boolean)true) : ItemStack.f_41583_;
            ItemStack last_result = GsonHelper.m_13900_((JsonObject)pSerializedRecipe, (String)"previous_result") ? CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"previous_result"), (boolean)true) : ItemStack.f_41583_;
            JsonObject toolObject = GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"tool");
            Ingredient toolIn = Ingredient.m_43917_((JsonElement)toolObject);
            boolean finished = !GsonHelper.m_13900_((JsonObject)pSerializedRecipe, (String)"finished") || GsonHelper.m_13912_((JsonObject)pSerializedRecipe, (String)"finished");
            return new TangyuanRecipe((NonNullList<Ingredient>)inputs, output, container, last_result, finished, toolIn, pRecipeId);
        }

        @Nullable
        public TangyuanRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            int ingredientCount = pBuffer.readInt();
            NonNullList inputs = NonNullList.m_122780_((int)ingredientCount, (Object)Ingredient.f_43901_);
            for (int i = 0; i < ingredientCount; ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)pBuffer));
            }
            ItemStack output = pBuffer.m_130267_();
            ItemStack container = pBuffer.m_130267_();
            ItemStack last_result = pBuffer.m_130267_();
            Ingredient toolIn = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            boolean finished = pBuffer.readBoolean();
            return new TangyuanRecipe((NonNullList<Ingredient>)inputs, output, container, last_result, finished, toolIn, pRecipeId);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, TangyuanRecipe pRecipe) {
            pBuffer.writeInt(pRecipe.inputItems.size());
            for (Ingredient ingredient : pRecipe.m_7527_()) {
                ingredient.m_43923_(pBuffer);
            }
            pBuffer.writeItemStack(pRecipe.m_8043_(null), false);
            pBuffer.m_130055_(pRecipe.getContainer());
            pBuffer.writeItemStack(pRecipe.getCacheItem(), false);
            pRecipe.getTool().m_43923_(pBuffer);
            pBuffer.writeBoolean(pRecipe.isFinished());
        }
    }

    public static class Type
    implements RecipeType<TangyuanRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "tangyuan";
    }
}

